#include <GL/glut.h>

float fRotY = 0.0f;
float fRotX = 0.0f;

bool bFlat = false;
bool bLight = true;

void display(void)
	{
   glClearColor (0.0, 0.0, 0.0, 0.0);
   glClear (GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
   glColor3f (1.0, 1.0, 1.0);
   glLoadIdentity ();             // egysgmtrix
   //
	// nzpont transzformci viewing transformation 
	// 
 	glTranslatef(0.0,0.0, -30.0);
	glRotatef(fRotY, 0.0f, 1.0f, 0.0f); 
	glRotatef(fRotX, 1.0f, 0.0f, 0.0f); 
	if (bFlat)
		{
		glShadeModel(GL_FLAT);
		}
	else
		{
		glShadeModel(GL_SMOOTH);
		}
	if(bLight)
		{
		glEnable(GL_LIGHTING);
		}
	else
		{
		glDisable(GL_LIGHTING);
		}
	//
	// model transformacio
	//
	glutSolidSphere(10.0,16,16);
	glutSwapBuffers();
	}
//
// viewport, projekci, s transformci
//
void reshape (int w, int h)
	{
   glViewport (0, 0, w, h); 
   glMatrixMode (GL_PROJECTION);
   glLoadIdentity ();
	gluPerspective (60.0, 1.0, 10.0, 1000.0);
	glMatrixMode (GL_MODELVIEW);	

	}

void initgl()
	{
	glEnable(GL_DEPTH_TEST);	
	glEnable(GL_LIGHTING);
	glEnable(GL_LIGHT0);
//	float lmodel_ambient[]={.9,.9,.9};
//	glLightModelfv(GL_LIGHT_MODEL_AMBIENT, lmodel_ambient);
	}

void keyboard(unsigned char key, int x, int y)
	{
   switch (key) 
		{
      case 'w':
			fRotX += 5.0f;
      break;
		case 's':
			fRotX -= 5.0f;
      break;
      case 'a':
			fRotY -= 5;
      break;
		case 'd':
			fRotY += 5;
      break;
		case 'f':
			bFlat = !bFlat;
		break;
		case 'l':
			bLight = !bLight;
		break;
		}
	glutPostRedisplay();	
	}

int main()
	{
	glutInitDisplayMode (GLUT_DOUBLE | GLUT_RGB);
   glutInitWindowSize (600, 600); 
   glutCreateWindow ("rnyals");
   glutDisplayFunc(display); 
   glutReshapeFunc(reshape);
	initgl();
	glutKeyboardFunc(keyboard);
   glutMainLoop();
   return 0;
	}


